<?php
function convertToReadableSize($size)
{
  $base = log($size) / log(1024);
  $suffix = array("", "KB", "MB", "GB", "TB");
  $f_base = floor($base);
  return round(pow(1024, $base - floor($base)), 1) . ' ' . $suffix[$f_base];
}
include('includes/header.php');

$userCod = $_SESSION['cod'];
?>

<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.3.1/css/all.css" integrity="sha384-mzrmE5qonljUremFsqc01SB46JvROS7bZs3IO2EmfFsd15uHvIt+Y8vEf7N7fWAU" crossorigin="anonymous">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
<link href="https://use.fontawesome.com/releases/v5.0.1/css/all.css" rel="stylesheet">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.3/jquery.min.js"></script>

<!DOCTYPE html>
<html>

<body>
  <div class="container-fluid px-lg-5 mx-auto" style="max-width: 1500px;">
    <div class="card-body">
      <div class="card futuristic-card">
        <div class="card-header card-header-warning">
          <center>
            <h2><i class="fa fa-upload"></i> Fazer upload de arquivos de até 300MB</h2>
          </center>
        </div>

        <div class="card-header card-header-warning">
          <center>
            <p class="font-weight-bold text-white">
              <i class="fa fa-exclamation-triangle text-warning"></i> Upe a imagem e o app com os mesmo nome para facilitar.<br>
              Se seu arquivo for maior que 300mb solicite ao ADM para upar!<br>
              <span style="color: #ec03fc;">Após upar o arquivo copie a url dele e vá em: Gerenciar App e crie um novo App, Coloque todos os dados e salve, em seguida edite o app pra adicionar o codigo dele</span>
            </p>
          </center>
        </div>

        <center>
          <form method="POST" action="uploadcom.php" enctype="multipart/form-data">
            <div class="input-group mb-3" style="max-width: 700px;">
              <div class="custom-file">
                <input type="file" class="custom-file-input" name="file">
                <label class="custom-file-label" for="file">Escolher arquivo</label>
              </div>
              <div class="input-group-append text-info">
                <button type="submit" value="Upload" name="Upload" class="btn btn-primary" style="background-color: #fec60f!important;border-color: #fec60f!important;color: #000;font-weight: 900">Enviar</button>
              </div>
            </div>
          </form>
        </center>

        <div class="table-responsive" style="margin-top: 1rem;">
          <table class="table table-striped table-dark">
            <tr>
              <th>ID</th>
              <th>URL</th>
              <th></th>
              <th>Ação</th>
            </tr>
            <?php
            $files = array_values(array_diff(scandir('uploads/' . $userCod), ['.', '..']));
            if ($files) {
              for ($a = 0; $a < count($files); $a++) {
            ?>
                <tr>
                  <td><?php echo $a + 1; ?></td>
                  <td>
                    <b style="color:white">https://<?php echo $_SERVER["HTTP_HOST"]; ?>/uploads/<?= $userCod ?>/<?php echo $files[$a]; ?></b>
                    <button class="btn btn-sm btn-outline-light copy-btn" data-clipboard-text="https://<?php echo $_SERVER["HTTP_HOST"]; ?>/uploads/<?= $userCod ?>/<?php echo $files[$a]; ?>">
                      <i class="far fa-copy"></i> Copiar
                    </button>
                  </td>
                  <td></td>
                  <td>
                    <a href="delete.php?name=uploads/<?php echo $userCod . '/' . $files[$a]; ?>">
                      <i data-toggle="tooltip" title="Delete Img" class="far fa-trash-alt fa-lg text-danger"></i>
                    </a>
                  </td>
                </tr>
            <?php
              }
            } else {
              echo '<tr><td colspan="4" style="color:#fec60f;" class="text-center"><p><i class="fas fa-inbox" style="font-size: 40px;"></i><br>No files uploaded!</p></td></tr>';
            }
            ?>
          </table>
        </div>
      </div>
    </div>
  </div>

  <script>
    document.querySelectorAll('.copy-btn').forEach(button => {
      button.addEventListener('click', function() {
        const textToCopy = this.getAttribute('data-clipboard-text');
        navigator.clipboard.writeText(textToCopy).then(() => {
          const icon = this.querySelector('i');
          const originalClass = icon.className;
          icon.className = 'fas fa-check';
          setTimeout(() => {
            icon.className = originalClass;
          }, 2000);
        }).catch(err => {
          console.error('Erro ao copiar texto: ', err);
        });
      });
    });
  </script>

  <?php
  if (isset($_GET['error']) && !empty($_GET['error'])) {
    switch ($_GET['error']) {
      case 'filetype':
        echo "<script>alert('ERRO. Só são aceitos arquivos JPEG, PNG ou APK.');</script>";
        echo "<meta http-equiv=\"refresh\" content=\"0; URL='./upload.php'\"/>\n";
        break;
      case 'filesize':
        echo "<script>alert('ERRO. Seu arquivo é superior a 300 MB.');</script>";
        echo "<meta http-equiv=\"refresh\" content=\"0; URL='./upload.php'\"/>\n";
        break;
    }
  }
  include('includes/footer.php');
  ?>

  <style>
    body {
      background: linear-gradient(135deg, #0f2027, #203a43, #2c5364);
      color: #fff;
      font-family: 'Orbitron', sans-serif;
    }

    .card-group {
      display: flex;
      flex-wrap: wrap;
      justify-content: center;
    }

    .col-md-4 {
      display: flex;
      justify-content: center;
    }

    .card {
      border: none;
      border-radius: 1rem;
      overflow: hidden;
      transition: transform 0.3s ease, box-shadow 0.3s ease;
      box-shadow: 0 8px 20px rgba(0, 255, 255, 0.1);
      background: #1a1a1a;
      margin: 1rem;
      width: 100%;
      max-width: 1500px;
      margin: 1rem auto; /* centraliza */
    }

    .card:hover {
      transform: scale(1.03);
      box-shadow: 0 12px 25px rgba(0, 255, 255, 0.2);
    }

    .card-img-top {
      height: 200px;
      object-fit: cover;
      border-bottom: 2px solid #00ffcc;
    }

    .card-body {
      padding: 1rem;
    }

    .card-title h4 {
      font-weight: bold;
      color: #00ffff;
      margin-bottom: 0.5rem;
    }

    h5 {
      font-size: 0.95rem;
      color: #ccc;
    }

    .btn {
      background: #00ffcc;
      border: none;
      color: #000;
      font-weight: bold;
      transition: 0.3s;
    }

    .btn:hover {
      background: #00ffaa;
      transform: scale(1.05);
    }

    .card-footer {
      background: #111;
      color: #aaa;
      font-size: 0.8rem;
      padding: 0.75rem 1rem;
      border-top: 1px solid #00ffcc;
    }

    .body-bg {
      height: auto;
      left: 0;
      min-height: 100%;
      min-width: 1024px;
      position: fixed;
      top: 0;
      width: 100%;
      z-index: -1;
      opacity: 0.05;
    }
    
    .modal-content {
      background: #1a1a1a;
      color: #00ffff;
      border: none;
      border-radius: 1rem;
      box-shadow:
       0 0 0 2px #00ffff, /* simula borda externa */
       0 0 20px rgba(0, 255, 255, 0.3); /* glow externo */
      padding: 1rem;
    }


    .modal-header, .modal-footer {
     border: none;
     background-color: #111;
     color: #00ffff;
    }

    .modal-header h2 {
     color: #00ffff;
     font-family: 'Orbitron', sans-serif;
     text-align: center;
     width: 100%;
    }

   .modal-body {
    color: #ffffff;
    font-family: 'Orbitron', sans-serif;
    text-align: center;
    padding: 2rem;
    }

   .modal-footer .btn {
    background-color: #00ffcc;
    color: #000;
    font-weight: bold;
    border-radius: 0.5rem;
    padding: 0.5rem 1.5rem;
    transition: background 0.3s ease;
   }

  .modal-footer .btn:hover {
   background-color: #00ffaa;
   transform: scale(1.05);
  }
  
  .futuristic-card {
   max-width: 1500px;
   width: 100%;
   margin: 1rem auto;
   /* mantém seu estilo de borda e sombra */
   background: #1a1a1a;
   border-radius: 1rem;
   padding: 1.5rem;
   border: 2px solid #00ffff;
   box-shadow:
    0 0 10px rgba(0, 255, 255, 0.4),
    0 0 20px rgba(0, 255, 255, 0.2);
   transition: all 0.3s ease-in-out;
  }

  .futuristic-card:hover {
   transform: scale(1.02);
   box-shadow:
     0 0 15px rgba(0, 255, 255, 0.6),
     0 0 30px rgba(0, 255, 255, 0.3);
  }
</style>
</body>

</html>
